package ch.frankel.blog.validation.validator;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

/**
 * Denotes a class that has  birthdate property before a death date property.
 * 
 * @author <a href="http://blog.frankel.ch">Nicolas Frankel</a>
 */
@Target( { TYPE, ANNOTATION_TYPE })
@Retention(RUNTIME)
@Constraint(validatedBy = BirthDeathValidator.class)
public @interface BirthDeathCoherence {

	String message() default "{ch.frankel.blog.validation.constraints.birthdeath}";

	Class<?>[] groups() default {};

	Class<? extends Payload>[] payload() default {};
}
